#include "brycemouse.h"
#include "cpc.h"
#include "emudevice.h"
#include "mouse.h"
#include "joystick.h"

typedef struct
{
	BOOL ScrollFunction;
	BOOL AutoDetect;
} BryceMouse;
static BryceMouse mouse;

BOOL BryceMouse_GetAutoDetect(void)
{
	return mouse.AutoDetect;
}
void BryceMouse_SetAutoDetect(BOOL bState)
{
	mouse.AutoDetect = bState;
}

BOOL BryceMouse_GetScrollFunction(void)
{
	return mouse.ScrollFunction;
}
void BryceMouse_SetScrollFunction(BOOL bState)
{
	mouse.ScrollFunction = bState;
}

/* joystick device needs to pass in state of common etc */
unsigned char BryceMouse_ReadJoystickPort(int Index)
{
	unsigned char Data = 0x0ff;
	/* Bryce's mouse responds to joy 0 and 1? */
	if (Index!=1) 
	{
		/* scroll function enabled? */
		if (mouse.ScrollFunction)
		{
			signed int Wheel = Mouse_GetWheel();
			if (Wheel<0)
			{
				/* down on joystick 2 */
				Data &= ~(1<<1);
			}
			else if (Wheel>0)
			{
				/* up on joystick 1 */
				Data &= ~(1<<0);
			}
		}
	}
	else
	{
		signed int X = Mouse_GetX();
		signed int Y = Mouse_GetY();
		int Buttons = Mouse_GetButtons();
		
		/* left */
		if (Buttons&1)
		{
			Data &=~(1<<4);
		}
		/* right */
		if (Buttons&2)
		{
			Data &=~(1<<5);
		}

		/* middle */
		if (Buttons&4)
		{
			Data &=~(1<<6);
		}

		if (X<0)
		{
			Data &= ~(1<<2);
		}
		else if (X>0)
		{
			Data &= ~(1<<3);
		}


		if (Y<0)
		{
			Data &= ~(1<<0);
		}
		else if (Y>0)
		{
			Data &= ~(1<<1);
		}

		/* TODO: allow devices to connect to multiplay?? */
		Data = Joystick_AdjustValueBasedOnHardware(Index, Data);
	}
	return Data;
}


static EmuDeviceSwitch BryceMouseSwitches[2]=
{
  {
      "Auto Detect on/off",
	  "AutoDetect",
      BryceMouse_GetAutoDetect,
      BryceMouse_SetAutoDetect
  },
  {
      "Scroll function on/off",
	  "ScrollWheel",
      BryceMouse_GetScrollFunction,
	BryceMouse_SetScrollFunction
  }
};

void BryceMouseDevice_Init(void)
{
	mouse.AutoDetect = FALSE;
	mouse.ScrollFunction = FALSE;
}

static EmuDevice m_BryceMouseDevice =
{
	NULL,
	BryceMouseDevice_Init,
	NULL,
    "BryceMouse",
	"BryceMouse",
    "Bryce's USB Mouse",
	CONNECTION_JOYSTICK,   /* connected to expansion */
	0,			/* flags */
	0,                /* no read ports */
	NULL,
	0,                    /* no write ports */
	NULL, /* the ports */
	0,                /* no memory read*/
	NULL,
	0,                    /* no memory write */
	NULL, /* the ports */
	NULL, /* reset function */
	NULL, /* memory rethink */
	NULL, /* power function */
	2,                      /* two switches */
	BryceMouseSwitches,
	0,                      /* no button */
	NULL,
	0,
	NULL,
	0,                      /* no onboard roms */
	NULL,
	NULL,	/* no cursor update function */
	NULL,	/* expansion roms */
	NULL,	/* printer */
	BryceMouse_ReadJoystickPort,	/* joystick */
	0,
	NULL,
	NULL,	/* no sound */
	NULL,
	NULL,   /* no reti */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

void BryceMouse_Init()
{
    RegisterDevice(&m_BryceMouseDevice);
}
